function init() {
  $('#telefono').on('input', function() {
    // Remove any non-digit characters
    $(this).val($(this).val().replace(/\D/g, ''));
});
  // Simula cargar el JSON de los clientes
const clientesJSON = {
  "clientes": [
      {
          "id": "2341",
          "nombreURL": "posperu",
          "nombre": "Cliente 1",
          "facebook": {
              "enlace": "https://www.facebook.com/posperu.com.pe/",
              "icono": "fab fa-facebook",
              "nombre": "Facebook"
          },
          "instagram": {
              "enlace": "https://www.instagram.com/posperusac/?hl=es-la",
              "icono": "fab fa-instagram",
              "nombre": "Instagram"
          },
          "whatsapp": {
              "enlace": "https://api.whatsapp.com/send?phone=956379825&text=Hola%21%20Quisiera%20m%C3%A1s%20informaci%C3%B3n%20sobre%20El%20Sistema.",
              "icono": "fab fa-whatsapp",
              "nombre": "WhatsApp"
          },
          "paginaweb": {
            "enlace": "https://posperu.com/",
            "icono": "fas fa-globe",
            "nombre": "Página web"
          },
          "tiktok": {
            "enlace": "https://www.tiktok.com/@posperu",
            "icono": "fab fa-tiktok",
            "nombre": "Tiktok"
          },
          "formulario": {
            "enlace": "natalinicol22@gmail.com",
            "icono": "fas fa-clipboard",
            "nombre": "Formulario"
          },
          "brochure": {
              "enlace": "brochure_posperu.pdf",
              "icono": "fas fa-file-alt",
              "nombre": "Brochure"
          },
          "contacto": {
            "correo": "-",
            "enlace": "posperu.com",
            "telefono": "956379825",
            "icono": "fas fa-envelope",
            "nombre": "Contacto"
        },
        "youtube": {
          "enlace": "https://www.youtube.com/@Posperu",
          "icono": "fab fa-youtube",
          "nombre": "Youtube"
        }
      },
      {
        "id": "12",
        "nombreURL": "yakumas",
        "nombre": "Cliente 1",
        "facebook": {
            "enlace": "https://www.facebook.com/AguaDeLosIncas?locale=es_LA",
            "icono": "fab fa-facebook",
            "nombre": "Facebook"
        }, 
        "paginaweb": {
          "enlace": "https://www.sne.org.pe/",
          "icono": "fas fa-globe",
          "nombre": "Página web"
        },
        "contacto": {
          "correo": "-",
          "enlace": "www.sne.org.pe",
          "telefono": "-",
          "icono": "fas fa-envelope",
          "nombre": "Contacto"
      }
    },
      // Agrega más registros de clientes aquí
  ]
};

function obtenerNombreClienteDeURL() {
  const pathArray = window.location.pathname.split('/');
  const clienteNombreURL = pathArray[pathArray.length - 1];
  return clienteNombreURL;
}
// Función para construir los enlaces personalizados
function construirEnlacesPersonalizados(clienteNombreURL) {
  if (clienteNombreURL) {
      const cliente = clientesJSON.clientes.find(cliente => cliente.nombreURL === clienteNombreURL);
      if (cliente) {
          construirEnlaceSiExiste(cliente, "facebook", "facebook-link-container");
          construirEnlaceSiExiste(cliente, "instagram", "instagram-link-container");
          construirEnlaceSiExiste(cliente, "whatsapp", "whatsapp-link-container");
          construirEnlaceSiExiste(cliente, "paginaweb", "paginaweb-link-container");
          construirEnlaceSiExiste(cliente, "brochure", "brochure-link-container", abrirModalBrochure);
          construirEnlaceSiExiste(cliente, "formulario", "formulario-link-container", abrirModalFormulario);
          construirEnlaceSiExiste(cliente, "contacto", "contacto-link-container", abrirModalContacto);
          construirEnlaceSiExiste(cliente, "tiktok", "tiktok-link-container");
          construirEnlaceSiExiste(cliente, "youtube", "youtube-link-container");
      }
  }
}

// Función para construir un enlace personalizado y agregarlo al contenedor si existe
function construirEnlaceSiExiste(cliente, servicio, contenedorId, clickHandler) {
  if (cliente[servicio] && cliente[servicio].enlace) {
      const enlaceCompleto = clickHandler ? `#` : `${cliente[servicio].enlace}`;
      $('#'+contenedorId).html(`<div class="card mb-4">
              <a href="${enlaceCompleto}" target="${clickHandler ? '' : '_blank'}" class="card-body text-center" ${clickHandler ? `onclick="return ${clickHandler.name}('${cliente[servicio].enlace}');"` : ''}>
              <h3><i class="${cliente[servicio].icono}"></i> ${cliente[servicio].nombre}</h3>
            </a>
        </div>
      `);  
  }
}

// Función para abrir el modal del formulario y configurar el correo destino
function abrirModalFormulario(correoDestino) {
  $("#correoDestino").val(correoDestino);
  $('#formularioModal').modal('show');
  return false; // Prevenir la navegación del enlace
}
// Función para abrir el modal de contacto y mostrar los datos
function abrirModalContacto(correo) {
  const cliente = clientesJSON.clientes.find(cliente => cliente.contacto.enlace === correo);
  if (cliente) {
    $("#contactoNombre").html(`<i class="fas fa-globe"></i> ${cliente.contacto.enlace}`);
    $("#contactoCorreo").html(`<i class="fas fa-envelope"></i> ${cliente.contacto.correo}`);
    $("#contactoTelefono").html(`<i class="fas fa-phone"></i> ${cliente.contacto.telefono}`);
  }
  $('#contactoModal').modal('show');
  return false; // Prevenir la navegación del enlace
}
function abrirModalBrochure(enlace) {
  $('#brochureIframe').attr('src', 'brochure_pdf/'+enlace);
  $('#brochureModal').modal('show');
  return false; // Prevenir la navegación del enlace
}
 
$('#contactForm').submit(function(event) {
  event.preventDefault();

  const formData = {
    nombre: $("#nombre").val(),
    email: $("#email").val(),
    telefono: $("#telefono").val(),
    mensaje: $("#mensaje").val(),
    correoDestino: $("#correoDestino").val()
  };
//   console.log(formData);

  // $.ajax({
  //   type: "POST",
  //   url: "tu_endpoint_de_correo", // URL de tu endpoint en el servidor
  //   data: formData,
  //   success: function(response) {
  //     console.log("Correo enviado exitosamente:", response);
  //     // Aquí puedes mostrar un mensaje de éxito al usuario si lo deseas
      $('#formularioModal').modal('hide');
      $('#contactForm')[0].reset();
  //   },
  //   error: function(error) {
  //     console.error("Error al enviar correo:", error);
  //     // Aquí puedes mostrar un mensaje de error al usuario si lo deseas
  //   }
  // });
});

// Llama a la función para construir los enlaces personalizados al cargar la página
window.onload = function() {
  const clienteNombreURL = obtenerNombreClienteDeURL();
  construirEnlacesPersonalizados(clienteNombreURL);
};

// Asegúrate de que abrirModalFormulario esté disponible globalmente
window.abrirModalFormulario = abrirModalFormulario;
window.abrirModalContacto = abrirModalContacto;
window.abrirModalBrochure = abrirModalBrochure;

}

 



init();
